/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*  Fluent Bit
 *  ==========
 *  Copyright (C) 2015-2025 The Fluent Bit Authors
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef FLB_VERSION_H
#define FLB_VERSION_H

#include <fluent-bit/flb_info.h>
#include <fluent-bit/flb_motd.h>
#include <monkey/mk_core.h>

#include <stdio.h>
#include <stdlib.h>

/* Helpers to convert/format version string */
#define STR_HELPER(s)      #s
#define STR(s)             STR_HELPER(s)

/* Fluent Bit Version */
#define FLB_VERSION_MAJOR   4
#define FLB_VERSION_MINOR   0
#define FLB_VERSION_PATCH   13
#define FLB_VERSION         (FLB_VERSION_MAJOR * 10000 \
                             FLB_VERSION_MINOR * 100   \
                             FLB_VERSION_PATCH)
#define FLB_VERSION_STR     "4.0.13"
#define FLB_GIT_HASH        "2a1d3c5d7f5b4de13bb5fdb3ae7800e805eac775"

static inline void flb_version()
{
#ifdef FLB_NIGHTLY_BUILD
    printf("Fluent Bit v%s | NIGHTLY_BUILD=%s - DO NOT USE IN PRODUCTION!\n",
           FLB_VERSION_STR, STR(FLB_NIGHTLY_BUILD));
#else
    printf("Fluent Bit v%s\n", FLB_VERSION_STR);
#endif
    printf("Git commit: %s\n", FLB_GIT_HASH);

    exit(EXIT_SUCCESS);
}

static inline void flb_version_banner()
{
    const char *copyright_color = ANSI_BOLD ANSI_YELLOW;
    const char *bold_color = ANSI_BOLD;
    const char *reset_color = ANSI_RESET;

    #ifdef FLB_LOG_NO_CONTROL_CHARS
    copyright_color = "";
    bold_color = "";
    reset_color = "";
    #else
    /* Only print colors to a terminal */
    if (!isatty(STDOUT_FILENO)) {
        copyright_color = "";
        bold_color = "";
        reset_color = "";
    }
    #endif // FLB_LOG_NO_CONTROL_CHARS

#ifdef FLB_NIGHTLY_BUILD
    fprintf(stderr,
            "%sFluent Bit v%s | NIGHTLY_BUILD=%s - DO NOT USE IN PRODUCTION!"
            "%s\n", bold_color, FLB_VERSION_STR, STR(FLB_NIGHTLY_BUILD), reset_color);
#else
    fprintf(stderr,
            "%sFluent Bit v%s%s\n", bold_color, FLB_VERSION_STR, reset_color);
#endif
    fprintf(stderr, "* %sCopyright (C) 2015-2025 The Fluent Bit Authors%s\n",
            copyright_color, reset_color);
    fprintf(stderr, "* Fluent Bit is a CNCF sub-project under the "
            "umbrella of Fluentd\n");
    fprintf(stderr, "* https://fluentbit.io\n\n");

#ifdef FLB_MOTD_H
    fprintf(stderr, "%s", flb_motd_text);
#endif

}

#endif
